@extends('layouts.master')

@section('content')

    <style>
        @font-face {
            font-family: 'Jameel Noori Nastaleeq';
            src: url('path/to/JameelNooriNastaleeq.woff') format('woff'),
                url('path/to/JameelNooriNastaleeq.ttf') format('truetype');
        }

        .az-content-label-ur {
            font-family: 'Jameel Noori Nastaleeq', serif;
            font-size: 2vh;

            /* margin-bottom: 15px; */
            line-height: 2;
        }

        .urdu-font {
            font-size: 17px;
        }
    </style>
    <!-- Breadcrumb and Page Title -->
    <div class="az-content-breadcrumb">
        <h2 class="az-content-title" style="display: inline">Purchase Report</h2>
    </div>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Generate Purchase Report</h5>
                <form action="{{ route('purchase_report.generate') }}" method="POST">
                    @csrf
                    <!-- Error Display -->
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label" for="report_date_from">Date From</label>
                                <input type="text" id="report_date_from" name="report_date_from" class="form-control"
                                    value="{{ old('report_date_from') }}" required />
                            </div>
                            @error('report_date_from')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label" for="report_date">Date To</label>
                                <input type="text" id="report_date" name="report_date" class="form-control"
                                    value="{{ old('report_date') }}" required />
                            </div>
                            @error('report_date')
                                <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label urdu-font" style="float: inline-end;">
                                    <span style="color:red;">*</span>
                                    سپلائرز
                                </label>
                                <select class="form-control select2" name="supplier" id="supplier" required>
                                    <option value="">- Select -</option>
                                    @foreach ($suppliers as $key => $supplier)
                                        <option value="{{ $supplier->id_supplier }}">
                                            {{ $supplier->supplier_name }} | {{ $supplier->supplier_name_urdu }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            @error('supplier')
                                <span class="form-text text-danger">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <!-- Submit and Cancel Buttons -->
                    <div class="mt-5">
                        <button type="button" id="generate-report-btn" class="btn btn-primary">Generate</button>
                    </div>
                </form>
            </div>

            <div class="my-5 card p-3">
                <h1>Stock Report</h1>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Supplier</th>
                            <th>Main Product</th>
                            <th>Parent Product</th>
                            <th>Child Product</th>
                            <th>Marka</th>
                            <th>Bori</th>
                            <th>Weight</th>
                            <th>Rate</th>
                            <th>Amount</th>
                            <th>Labour Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $("#report_date").datepicker({
                dateFormat: "yy-mm-dd"
            });

            // for generate report
            // $('#generate-report-btn').click(function(e) {
            //     e.preventDefault();

            //     // Collect selected values
            //     const reportDate = $('#report_date').val();
            //     const supplierId = $('#supplier').val();

            //     // Validate inputs
            //     if (!reportDate || !supplierId) {
            //         alert('Please select a date and supplier.');
            //         return;
            //     }

            //     // AJAX request to generate report
            //     $.ajax({
            //         url: '{{ route('purchase_report.generate') }}',
            //         type: 'POST',
            //         data: {
            //             _token: '{{ csrf_token() }}',
            //             report_date: reportDate,
            //             supplier_id: supplierId,
            //         },
            //         success: function(response) {
            //             console.log(response);
            //             // Clear the table body
            //             const tableBody = $('table tbody');
            //             tableBody.empty();

            //             // Populate table with response data
            //             response.data.forEach(item => {
            //                 tableBody.append(`
        //         <tr>
        //             <td>${item.date}</td>
        //             <td>${item.supplier_name}</td>
        //             <td>${item.main_cate}</td>
        //             <td>${item.parent_cate}</td>
        //             <td>${item.child_cate}</td>
        //             <td>${item.marka}</td>
        //             <td>${item.bori}</td>
        //             <td>${item.weight}</td>
        //             <td>${item.rate}</td>
        //             <td>${item.amount}</td>
        //             <td>${item.labour_amount}</td>
        //         </tr>
        //     `);
            //             });
            //         },
            //         error: function(xhr) {
            //             console.error('Error generating report:', xhr.responseText);
            //             alert('Unable to generate report. Please try again.');
            //         }
            //     });
            // });



            
            // $('#generate-report-btn').click(function(e) {
            //     e.preventDefault();

            //     // Collect selected values
            //     const reportDate = $('#report_date').val();
            //     const supplierId = $('#supplier').val();

            //     // Validate inputs
            //     if (!reportDate || !supplierId) {
            //         alert('Please select a date and supplier.');
            //         return;
            //     }

            //     // AJAX request to generate report
            //     $.ajax({
            //         url: '{{ route('purchase_report.generate') }}', 
            //         type: 'POST',
            //         data: {
            //             _token: '{{ csrf_token() }}',
            //             report_date: reportDate,
            //             supplier_id: supplierId,
            //         },
            //         success: function(response) {
            //             console.log(response);
            //             const tableBody = $('table tbody');
            //             tableBody.empty(); // Clear existing rows

            //             if (response.data && response.data.length > 0) {
            //                 response.data.forEach(item => {
            //                     tableBody.append(`
        //             <tr>
        //                 <td>${item.date}</td>
        //                 <td>${item.supplier_name}</td>
        //                 <td>${item.main_cate}</td>
        //                 <td>${item.parent_cate}</td>
        //                 <td>${item.child_cate}</td>
        //                 <td>${item.marka}</td>
        //                 <td>${item.bori}</td>
        //                 <td>${item.weight}</td>
        //                 <td>${item.rate}</td>
        //                 <td>${item.amount}</td>
        //                 <td>${item.labour_amount}</td>
        //             </tr>
        //         `);
            //                 });
            //             } else {
            //                 tableBody.append(`
        //         <tr>
        //             <td colspan="11" class="text-center">No records found for the selected date and supplier.</td>
        //         </tr>
        //     `);
            //             }
            //         },
            //         error: function(xhr) {
            //             console.error('Error generating report:', xhr.responseText);
            //             alert('Unable to generate report. Please try again later.');
            //         }
            //     });
            // });


            $('#generate-report-btn').click(function(e) {
                e.preventDefault();

                const reportDate = $('#report_date').val();
                const supplierId = $('#supplier').val();

                if (!reportDate || !supplierId) {
                    alert('Please select a date and supplier.');
                    return;
                }

                $.ajax({
                    url: '{{ route('purchase_report.generate') }}',
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        report_date: reportDate,
                        supplier_id: supplierId,
                    },
                    success: function(response) {
                        const tableBody = $('table tbody');
                        tableBody.empty();

                        if (response.data && response.data.length > 0) {
                            response.data.forEach(row => {
                                tableBody.append(`
                        <tr>
                            <td>${row.date}</td>
                            <td>${row.supplier_name}</td>
                            <td>${row.main_cate}</td>
                            <td>${row.parent_cate}</td>
                            <td>${row.child_cate}</td>
                            <td>${row.marka}</td>
                            <td>${row.bori}</td>
                            <td>${row.weight}</td>
                            <td>${row.rate}</td>
                            <td>${row.amount}</td>
                            <td>${row.labour_amount}</td>
                        </tr>
                    `);
                            });
                        } else {
                            tableBody.append(`
                    <tr>
                        <td colspan="11" class="text-center">No records found for the selected date and supplier.</td>
                    </tr>
                `);
                        }
                    },
                    error: function(xhr) {
                        console.error('Error generating report:', xhr.responseText);
                        alert('Unable to generate report. Please try again later.');
                    }
                });
            });



        });
    </script>
@endpush
